/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.idm.toolkit;

import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;
import filenet.vw.idm.toolkit.IVWIDMFactoryProperties;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.idm.toolkit.VWOpenBrowser;
import filenet.ws.utils.WSConstants;
import java.applet.Applet;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;

public class IDMUtilities {
    private static Logger logger = Logger.getLogger("filenet.vw.idm");
    private static final String m_className = "IDMUtilities";
    private static int jsCheckedState = 0;

    public static synchronized boolean JavascriptEnabled() {
        if (jsCheckedState == 0) {
            try {
                Class<?> jsObjectCls = Class.forName("netscape.javascript.JSObject");
                jsCheckedState = 1;
            }
            catch (Throwable ex) {
                jsCheckedState = 2;
            }
        }
        return jsCheckedState == 1;
    }

    public static void openWindow(String pageURL, String title, String resizable, int width, int height) throws VWException {
        String m_method = "openWindow:" + pageURL;
        Applet m_applet = null;
        IVWIDMFactoryProperties factoryProperties = VWIDMBaseFactory.instance().getProperties();
        m_applet = (Applet)factoryProperties.getProperty("applet");
        if (m_applet == null || !m_applet.isActive()) {
            logger.warning(m_className, m_method, "exit - no applet available.");
            return;
        }
        logger.entering(m_className, m_method);
        VWOpenBrowser.init(m_applet);
        VWOpenBrowser.displayPage(pageURL);
        logger.exiting(m_className, m_method);
    }

    public static String toString(Object arr) {
        if (arr == null || !arr.getClass().isArray()) {
            return String.valueOf(arr);
        }
        StringBuffer sb = new StringBuffer();
        int len = Array.getLength(arr);
        sb.append('[');
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            Object obj = Array.get(arr, i);
            sb.append(IDMUtilities.toString(obj));
        }
        sb.append(']');
        return sb.toString();
    }

    public static String URLEncoder(String s) {
        return WSConstants.UTF8Encode(s);
    }

    public static String URLEncoder(String s, String enc) throws UnsupportedEncodingException {
        return WSConstants.UTF8Encode(s);
    }
}

